// Autor: Ante Derek

#include <iostream>
#include <vector>
#include <string>
#include <cstring>
#include <functional>

using namespace std;

const vector<vector<string>> TRIPLES = {
  {"a1", "d1", "g1"},
  {"b2", "d2", "f2"},
  {"c3", "d3", "e3"},
  {"d1", "d2", "d3"},
  {"g1", "g4", "g7"},
  {"f2", "f4", "f6"},
  {"e3", "e4", "e5"},
  {"e4", "f4", "g4"}
};

int triples[8][3][2];

const vector<string> MAP = {
  "x..x..x",
  ".x.x.x.",
  "..xxx..",
  "xxx.xxx",
  "..xxx..",
  ".x.x.x.",
  "x..x..x"
};

inline pair<int, int> to_pair(const string &s) {
  return {s[0]-'a', s[1]-'1'};
}


int current[7][7];
int full;

void debug() {
  for (int i=0; i<7; i++) {
    for (int j=0; j<7; j++)
      if (current[i][j] == -1)
        cerr << '.';
      else
        cerr << current[i][j];
    cerr << endl;
  }
  cerr << endl;
}


inline int count() {
  int cnt = 0;
  for (int i=0; i<8; i++) {
    int color[2];
    color[0] = color[1] = 0;
    for (int j=0; j<3; j++) {
      int temp = current[triples[i][j][0]][triples[i][j][1]];
      if (temp == -1)
        break ;
      color[temp]++;
    }
    if (color[0] == 3 || color[1] == 3)
      cnt++;
  }
  return cnt;
}

inline int diagonal() {
  int d = 0;
  for (int i=0; i<7; i++)
    if (i != 3)
      d = (d*3)+1+current[i][i];
  return d;
}

void work(int x, int y, function<void()> callback) {
  while (true) {
    if (y > x) 
      x++, y=0;
    if (x > 6) {
      callback();
      return ;
    }
    if (MAP[x][y] == 'x' && current[x][y] == -1)
      break ;
    y++;
  }
  if (!full) {
    work(x, y+1, callback);
  }
  current[x][y] = 0;
  work(x, y+1, callback);
  current[x][y] = 1;
  work(x, y+1, callback);
  current[x][y] = -1;
}

int main() {
  for (int i=0; i<8; i++)
    for (int j=0; j<3; j++) {
      auto p = to_pair(TRIPLES[i][j]);
      triples[i][j][0] = p.first;
      triples[i][j][1] = p.second;
    }
  string type;
  cin >> type;
  full = type == "puni";
  int n;
  cin >> n;
  memset(current, -1, sizeof current);
  for (int i=0; i<n; i++) {
    string s;
    string c;
    cin >> s >> c;
    auto p = to_pair(s);
    current[p.first][p.second] = c == "c" ? 1 : 0;
  }

  // Meet in the middle - prva faza
  int cnt[729][17]; // 729 == 3^6
  memset(cnt, 0, sizeof cnt);
  auto callback1 = [&] {
    cnt[diagonal()][count()]++;
  };  
  work(0, 0, callback1);

  // flip
  for (int i=0; i<7; i++)
    for (int j=0; j<i; j++)
      swap(current[i][j], current[j][i]);

  // druga faza
  long long total[17];
  memset(total, 0, sizeof total);
  auto callback2 = [&] {
    int d = diagonal();
    int c = count();
    for (int i=0; c+i<17; i++)
      total[c+i] += cnt[d][i];
  };
  work(0, 0, callback2);
   
  for (int i=0; i<17; i++) {
    if (i > 0)
      cout << " ";
    cout << total[i];
  }
  cout << endl;
}
